* likepois_random.sas;
options pageno=1 linesize=80;
goptions reset=all;
title "Plot L(lambda) for Poisson data vs. lambda";
data likepois;
	* Generate n random Poisson observations with parameter lambda;
	%let n = 3;
	lambda_true = 6; 
	array ydata (&n) y1-y&n;
	do i=1 to &n;
		ydata(i) = ranpoi(0,lambda_true); 
	end;
	* Find likelihood as function of lambda;
	do lambda=0.1 to 15 by 0.1;
		Llambda = 1;
		do i=1 to &n;
			Llambda = Llambda*pdf('poisson',ydata(i),lambda);
		end;
		output;
	end;
run;
* Print data;
proc print data=likepois;
run;
* Plot likelihood as a function of lambda;
proc gplot data=likepois;
	plot Llambda*lambda=1 / vaxis=axis1 haxis=axis1;
	symbol1 i=join v=none c=red width=3;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
run;
quit;
